/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArray;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"irrelevant")});
    }

    public void testMatchesAnArrayThatMatchesAllTheElementMatchers() {
        IsArrayTest.assertMatches("should match array with matching elements", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b"), IsEqual.equalTo((Object)"c")}), new String[]{"a", "b", "c"});
    }

    public void testDoesNotMatchAnArrayWhenElementsDoNotMatch() {
        IsArrayTest.assertDoesNotMatch("should not match array with different elements", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b")}), new String[]{"b", "c"});
    }

    public void testDoesNotMatchAnArrayOfDifferentSize() {
        IsArrayTest.assertDoesNotMatch("should not match larger array", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b")}), new String[]{"a", "b", "c"});
        IsArrayTest.assertDoesNotMatch("should not match smaller array", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b")}), new String[]{"a"});
    }

    public void testDoesNotMatchNull() {
        IsArrayTest.assertDoesNotMatch("should not match null", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a")}), null);
    }

    public void testHasAReadableDescription() {
        IsArrayTest.assertDescription("[\"a\", \"b\"]", IsArray.array((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b")}));
    }
}

